package nemosofts.notes.app.dialog;

import static android.view.WindowManager.LayoutParams.MATCH_PARENT;
import static android.view.WindowManager.LayoutParams.WRAP_CONTENT;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.util.Patterns;
import android.view.Window;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.Objects;

import nemosofts.notes.app.R;

public class DialogUtil {

    private static Dialog dialog;

    private DialogUtil() {
        throw new IllegalStateException("Utility class");
    }

    // Dialog
    public static void exitDialog(Activity activity) {
        if (activity == null){
            return;
        }
        if (dialog != null){
            dialog = null;
        }
        dialog = new Dialog(activity);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_app);

        ImageView icon = dialog.findViewById(R.id.iv_dialog_icon);
        icon.setImageResource(R.drawable.ic_exit);

        // Optional shimmer animation or vector tint
        icon.animate().rotation(10).setDuration(300).withEndAction(() ->
                icon.animate().rotation(0).setDuration(300)
        );

        TextView title = dialog.findViewById(R.id.tv_dialog_title);
        title.setText(R.string.exit);

        TextView msg = dialog.findViewById(R.id.tv_dialog_msg);
        msg.setText(R.string.sure_exit);

        // Click listeners
        dialog.findViewById(R.id.iv_dialog_close).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_dialog_no).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_dialog_yes).setOnClickListener(view -> {
            dialog.dismiss();
            activity.finishAffinity();
        });

        // Window styling
        Objects.requireNonNull(dialog.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog.getWindow().getAttributes().windowAnimations = R.style.dialogAnimation;
        dialog.show();
        Window window = dialog.getWindow();
        if (window != null){
            window.setLayout(MATCH_PARENT, WRAP_CONTENT);
        }
    }

    public static void addURLDialog(Activity activity, AddListener listener) {
        if (activity == null){
            return;
        }
        if (dialog != null){
            dialog = null;
        }
        dialog = new Dialog(activity);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_add);

        ImageView icon = dialog.findViewById(R.id.iv_dialog_icon);
        icon.setImageResource(R.drawable.ic_web);

        // Optional shimmer animation or vector tint
        icon.animate().rotation(10).setDuration(300).withEndAction(() ->
                icon.animate().rotation(0).setDuration(300)
        );

        final EditText inputURL = dialog.findViewById(R.id.et_cat);
        inputURL.setHint(activity.getString(R.string.enter_url));

        // Click listeners
        dialog.findViewById(R.id.iv_dialog_close).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_no).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_yes).setOnClickListener(view -> {
            if (inputURL.getText().toString().trim().isEmpty()){
                inputURL.setError(activity.getString(R.string.error_url));
                return;
            } else if (!Patterns.WEB_URL.matcher(inputURL.getText().toString()).matches()){
                inputURL.setError(activity.getString(R.string.error_url));
                return;
            }
            dialog.dismiss();
            listener.onAdd(inputURL.getText().toString());
        });

        // Window styling
        Objects.requireNonNull(dialog.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog.getWindow().getAttributes().windowAnimations = R.style.dialogAnimation;
        dialog.show();
        Window window = dialog.getWindow();
        if (window != null){
            window.setLayout(MATCH_PARENT, WRAP_CONTENT);
        }
    }

    public static void trashDialog(Context context, DeleteListener listener) {
        if (dialog != null){
            dialog = null;
        }
        dialog = new Dialog(context);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_app);

        ImageView icon = dialog.findViewById(R.id.iv_dialog_icon);
        icon.setImageResource(R.drawable.ic_trash);

        // Optional shimmer animation or vector tint
        icon.animate().rotation(10).setDuration(300).withEndAction(() ->
                icon.animate().rotation(0).setDuration(300)
        );

        TextView title = dialog.findViewById(R.id.tv_dialog_title);
        title.setText(R.string.delete);

        TextView msg = dialog.findViewById(R.id.tv_dialog_msg);
        msg.setText(R.string.sure_delete);

        dialog.findViewById(R.id.iv_dialog_close).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onCancel();
        });

        dialog.findViewById(R.id.tv_dialog_no).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onCancel();
        });
        dialog.findViewById(R.id.tv_dialog_yes).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onDelete();
        });

        Objects.requireNonNull(dialog.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog.getWindow().getAttributes().windowAnimations = R.style.dialogAnimation;
        dialog.show();
        Window window = dialog.getWindow();
        if (window != null){
            window.setLayout(MATCH_PARENT, WRAP_CONTENT);
        }
    }

    public static void trashRecycleDialog(Activity activity, DeleteListener listener) {
        if (dialog != null){
            dialog = null;
        }
        dialog = new Dialog(activity);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_app);

        ImageView icon = dialog.findViewById(R.id.iv_dialog_icon);
        icon.setImageResource(R.drawable.ic_trash);

        // Optional shimmer animation or vector tint
        icon.animate().rotation(10).setDuration(300).withEndAction(() ->
                icon.animate().rotation(0).setDuration(300)
        );

        TextView title = dialog.findViewById(R.id.tv_dialog_title);
        title.setText(R.string.move_to_recycle_bin);

        TextView msg = dialog.findViewById(R.id.tv_dialog_msg);
        msg.setText(R.string.are_you_sure_you_want_to_move_to_recycle_bin_this_note);

        dialog.findViewById(R.id.iv_dialog_close).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onCancel();
        });

        dialog.findViewById(R.id.tv_dialog_no).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onCancel();
        });

        dialog.findViewById(R.id.tv_dialog_yes).setOnClickListener(view -> {
            dialog.dismiss();
            listener.onDelete();
        });

        Objects.requireNonNull(dialog.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog.getWindow().getAttributes().windowAnimations = R.style.dialogAnimation;
        dialog.show();
        Window window = dialog.getWindow();
        if (window != null){
            window.setLayout(MATCH_PARENT, WRAP_CONTENT);
        }
    }

    public static void addCategoriesDialog(Activity activity, AddListener listener) {
        if (activity == null){
            return;
        }
        if (dialog != null){
            dialog = null;
        }
        dialog = new Dialog(activity);
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE);
        dialog.setContentView(R.layout.dialog_add);

        ImageView icon = dialog.findViewById(R.id.iv_dialog_icon);
        icon.setImageResource(R.drawable.ic_folders);

        // Optional shimmer animation or vector tint
        icon.animate().rotation(10).setDuration(300).withEndAction(() ->
                icon.animate().rotation(0).setDuration(300)
        );

        final EditText inputCatName = dialog.findViewById(R.id.et_cat);
        inputCatName.setHint(activity.getString(R.string.enter_categories_name));

        // Click listeners
        dialog.findViewById(R.id.iv_dialog_close).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_no).setOnClickListener(view -> dialog.dismiss());
        dialog.findViewById(R.id.tv_yes).setOnClickListener(view -> {
            if (inputCatName.getText().toString().trim().isEmpty()){
                inputCatName.setError(activity.getString(R.string.enter_categories_name));
                return;
            }
            dialog.dismiss();
            listener.onAdd(inputCatName.getText().toString());
        });

        // Window styling
        Objects.requireNonNull(dialog.getWindow()).setBackgroundDrawableResource(android.R.color.transparent);
        dialog.getWindow().getAttributes().windowAnimations = R.style.dialogAnimation;
        dialog.show();
        Window window = dialog.getWindow();
        if (window != null){
            window.setLayout(MATCH_PARENT, WRAP_CONTENT);
        }
    }

    // Listener
    public interface AddListener {
        void onAdd(String string);
    }

    public interface DeleteListener {
        void onDelete();
        void onCancel();
    }
}